create_clock -name sys_clk -period 10 [get_ports PCIE_REFCLK_P]

set_false_path -from [get_ports PCIE_PERST_B_LS]

set_property PACKAGE_PIN V7 [get_ports PCIE_REFCLK_P]
set_property PACKAGE_PIN V6 [get_ports PCIE_REFCLK_N]

set_property -dict "IOSTANDARD LVCMOS18 PULLUP true PACKAGE_PIN T19" [get_ports PCIE_PERST_B_LS]

set_property PACKAGE_PIN C9 [get_ports "GPIO_LED[0]"]
set_property PACKAGE_PIN D9 [get_ports "GPIO_LED[1]"]
set_property PACKAGE_PIN E10 [get_ports "GPIO_LED[2]"]
set_property PACKAGE_PIN E11 [get_ports "GPIO_LED[3]"]
set_false_path -to [get_ports -filter {NAME=~GPIO_LED*}]
set_property IOSTANDARD LVCMOS33 [get_ports -filter {NAME=~GPIO_LED*}]

# Setting false paths by clock grouping
# sys_clk and pipe_clk:
set_clock_groups -name async1 -asynchronous -group [get_clocks {sys_clk}] \
    -group [get_clocks -of_objects [get_pins -hierarchical -filter {NAME =~ */*gt_top_i/*/phy_clk_i/bufg_gt_pclk/O}]]
# sys_clk and all TXOUTCLKs:
set_clock_groups -name async2 -asynchronous -group [get_clocks {sys_clk}] \
    -group [get_clocks -of_objects [get_pins -hierarchical -filter {NAME =~ *gen_channel_container[*].*gen_gtye4_channel_inst[*].GTYE4_CHANNEL_PRIM_INST/TXOUTCLK}]]

